package jamezo97.clonecraft.dna;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.CloneCraftUtils;
import jamezo97.clonecraft.Logger;
import jamezo97.clonecraft.entity.EntityModifiable;
import jamezo97.clonecraft.entity.EntitySpawnEgg;

import java.util.ArrayList;
import java.util.List;

import net.minecraft.entity.CCEntityAnything;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityEggInfo;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ItemData {

	ItemStack stack;

	public int currentEntity = -1;

	public int[] genes = new int[0];
	//	int[] geneStrength = new int[0];

	boolean isContaminated = false;

	public ItemData(){

	}

	public ItemData(ItemStack stack){
		load(stack.getTagCompound());
		this.stack = stack;
	}

	public ItemData setGene(int geneId) {
		if(!hasGene(geneId)){
			int[] copy = new int[genes.length+1];
			for(int a = 0; a < genes.length; a++){
				copy[a] = genes[a];
			}
			copy[genes.length] = geneId;
			genes = copy;
			isContaminated = true;
			sortGenes();
		}
		return this;
	}

	public void sortGenes(){
		int[] copy = genes.clone();
		int[] out = new int[genes.length];

		for(int a = 0; a < out.length; a++){
			int min = Integer.MAX_VALUE;
			int mindex = -1;
			for(int b = 0; b < copy.length; b++){
				if(copy[b] < min){
					mindex = b;
					min = copy[b];
				}
			}
			out[a] = min;
			copy[mindex] = Integer.MAX_VALUE;
		}
		this.genes = out;
	}

	public boolean hasGene(int geneId){
		for(int a = 0; a < genes.length; a++){
			if(genes[a] == geneId){
				return true;
			}
		}
		return false;
	}

	public void setEntity(int id){
		currentEntity = id;
		//		System.out.println(id + "," + CloneCraft.cloneId);
	}

	public void setEntity(EntityLivingBase e){
		setEntity(getEntityId(e));
		isContaminated = true;
	}

	private int getEntityId(EntityLivingBase e){
		if(e instanceof EntityPlayer){
			return CloneCraft.cloneId;
		}
		return EntityList.getEntityID(e);
	}

	public void save(ItemStack stack) {
		stack.setTagCompound(saveToNbt());
	}

	public boolean save(){
		if(stack != null){
			stack.setTagCompound(saveToNbt());
			return true;
		}
		return false;
	}

	public NBTTagCompound saveToNbt(){
		return save(new NBTTagCompound("tag"));
	}

	public NBTTagCompound save(NBTTagCompound nbt){
		if(nbt == null)nbt = new NBTTagCompound("tag");
		nbt.setInteger("currentEntity", currentEntity);
		nbt.setIntArray("genes", genes);
		nbt.setBoolean("isContaminated", isContaminated);
		return nbt;
	}


	public ItemData load(NBTTagCompound nbt){
		if(nbt != null){
			currentEntity = nbt.getInteger("currentEntity");
			genes = nbt.getIntArray("genes");
			if(genes.length > 1){
				sortGenes();
			}
			isContaminated = nbt.getBoolean("isContaminated");
		}
		return this;
	}

	public boolean isModified(){
		return genes.length > 0 && currentEntity != -1;
	}

	public boolean isFull(){
		//		System.out.println(genes.length);
		return currentEntity != -1 || genes.length > 0;
	}

	/**
	 * Get's the display name, to... display, for this DNA/blood mixture.
	 * @param itemName The name of the item, IE, test tube
	 * @param containing The stuff inside is, i.e., blood, DNA etc
	 * @param prefix 
	 * @param stack 
	 * @return
	 */
	public String getDisplayName(String itemName, String containing, String prefix, ItemStack stack){
		boolean isFull = isFull();
		boolean isModified = isModified();
		if(isFull && getCurrentEntityName() != null){
			String currentEntityName = getCurrentEntityName();
			return prefix + (isModified?"Modified ":"") + currentEntityName + " " + containing;
		}else if(isFull && genes.length > 0 && currentEntity == -1){
			return itemName + " Of " + containing;
		}else if(stack.itemID == CloneCraft.testTube.itemID && stack.getItemDamage() == 4){
			return prefix + containing;
		}else{
			return prefix + (isContaminated?"Contaminated ":"") + "Empty " + itemName;
		}
	}

	public int getColour(){
		if(currentEntity != -1){
			return getColour(currentEntity);
		}else{
			if(genes.length > 0){
				int[] colours = new int[genes.length];
				float[] percentages = new float[genes.length];
				for(int a = 0; a < colours.length; a++){
					Gene gene = Gene.getGene(genes[a]);
					if(gene != null){
						colours[a] = gene.getColour();
						percentages[a] = 1.0f / (float)colours.length;//(float)(colours.length-a) / (float)colours.length;
					}else{
						percentages[a] = 0.0f;
					}
				}
				return addColours(colours, percentages);
			}
			return 0xffffff;
		}
	}

	public final static int bloodColour = 0xff851212;


	private int getColour(int entityID){
		if(entityID == CloneCraft.cloneId){
			return bloodColour;
		}
		if(EntityList.entityEggs.containsKey(entityID)){
			return ((EntityEggInfo)EntityList.entityEggs.get(entityID)).primaryColor;
		}
		return 0xffffffff;
	}

	public static int addColours(int[] colours, float[] percentages){
		float size = 0;
		double allRed = 0;
		double allGreen = 0;
		double allBlue = 0;
		for(int a = 0; a < colours.length; a++){
			size += percentages[a];
			allRed += ((double)((colours[a] >> 16) & 0xff)) * percentages[a];
			allGreen += ((double)((colours[a] >> 8) & 0xff)) * percentages[a];
			allBlue += ((double)((colours[a]) & 0xff)) * percentages[a];
		}
		int red = 0, green = 0, blue = 0;
		if(size > 0){
			red = (int)Math.round(allRed / size);
			green = (int)Math.round(allGreen / size);
			blue = (int)Math.round(allBlue / size);
		}
		if(red < 1)red = 0;
		if(green < 1)green = 0;
		if(blue < 1)blue = 0;
		if(red > 255)red = 255;
		if(green > 255)green = 255;
		if(blue > 255)blue = 255;
		return 0xff000000 | (red << 16) | (green << 8) | (blue);
	}

	public String getCurrentEntityName(){
		return getEntityName(currentEntity);
	}

	public String getEntityName(int id){
		if(id == CloneCraft.cloneId){
			return "Human";
		}
		return EntityList.getStringFromID(id);
	}


	public ItemData drain() {
		currentEntity = -1;
		genes = new int[0];
		return this;
	}

	public ItemData cleanse() {
		drain();
		genes = new int[0];
		isContaminated = false;
		return this;
	}

	public void addInfo(List par3List, boolean isLShiftDown) {
		if(genes.length > 0){
			for(int a = 0; a < genes.length; a++){
				Gene gene = Gene.getGene(genes[a]);
				if(gene != null){
					par3List.add("\247" + CloneCraftUtils.getClosestColourChar(gene.getColour()) + gene.getName() + " \247fGene");
				}
			}
		}
	}

	public boolean isContaminated() {
		if(isFull()){
			isContaminated = true;
		}
		return isContaminated;
	}

	public void fillWith(ItemData nData) {
		this.currentEntity = nData.currentEntity;
		if(nData.isContaminated){
			this.isContaminated = true;
		}
	}


	public Entity spawnEntity(double posX, double posY, double posZ, World world){
		Entity toSpawn = null;
		try{
			toSpawn = EntityList.createEntityByID(currentEntity, world);
		}catch(Exception e){
			e.printStackTrace();
		}
		if(toSpawn != null){
			toSpawn.setPosition(posX, posY, posZ);

			if(toSpawn instanceof EntityLiving){
				((EntityLiving)toSpawn).onSpawnWithEgg(null);
			}
			if(containsGenes() && !cantMutateClass.contains(toSpawn.getClass()) && toSpawn instanceof EntityLiving){
				EntityModifiable entity;
				if(toSpawn instanceof EntityModifiable){
					entity = (EntityModifiable)toSpawn;
				}else{
					entity = new CCEntityAnything(world, (EntityLiving)toSpawn);
				}
				entity.setPosition(posX, posY, posZ);
				for(int a = 0; a < genes.length; a++){
					Gene gene = Gene.getGene(genes[a]);
					if(gene != null){
						entity.setGene(gene, gene.getMaxAmount());
					}
				}
				world.spawnEntityInWorld(entity);
				return toSpawn;
			}else{
				world.spawnEntityInWorld(toSpawn);
				return toSpawn;
			}
			

			
		}else{
			Logger.error("Could not spawn entity with id: " + currentEntity);
		}
		return toSpawn;
	}
	
	static ArrayList<Class> cantMutateClass = new ArrayList<Class>();
	
	static{
		cantMutateClass.add(EntityDragon.class);
	}

	public Entity spawn(MovingObjectPosition mop, EntitySpawnEgg egg) {
		if(isFull()){
			double x = mop.hitVec.xCoord, y = mop.hitVec.yCoord, z = mop.hitVec.zCoord;
			if(mop.entityHit != null){
				//				x += .01f;
				//				z += .01f;
			}else{
				switch(mop.sideHit){
				case 0: y-=2; break;
				case 2: z-=.5; break;
				case 3: z+=.5; break;
				case 4: x-=.5; break;
				case 5: x+=.5; break;
				}
			}

			return spawnEntity(x, y, z, egg.worldObj);
		}
		return null;
	}

	public boolean containsGenes() {
		return genes.length > 0;
	}

	public ItemData setContaminated() {
		isContaminated = true;
		return this;
	}






}
